package com.izenpe.zain.cliente.xades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaXML {
	// Nombre del fichero a utilizar para la Verificacin de la firma XML.
//	private static final String signName = "DemoSignedEnveloped.xml";
//	private static final String signName = "DemoSignedEnveloping.xml";
//	private static final String signName = "DemoSignedEnvelopingTS.xml";
//	private static final String signName = "PruebaPDFSignedEnvelopingTS.xml";
//	private static final String signName = "HelloWorldSignedEnvelopingTS.xml";
//	private static final String signName = "DemoSignedEnveloped-Paralelo.xml";
//	private static final String signName = "DemoSignedDetached.xml";
//	private static final String signName = "DemoSignedEnvelopingMulti.xml";
//	private static final String signName = "DemoSignedEnvelopedSignedEnveloped-Serie.xml";
//	private static final String signName = "DemoSignedEnvelopingSignedEnveloping-Serie.xml";
	private static final String signName = "DemoSignedEnvelopingTSArchive.xml";

	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil XML (XADES) en la peticin de Verificacin
			// de firma.
			smartVerifyReq.setProfile(Constants.Profile.XADES);
			

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			/*
			 * True para que la respuesta incluya el formato de la firma (e.g.
			 * BES, ES-T). La invocacin de mtodo es indispensable para
			 * consultar el formato de la respuesta con getSignatureForm.
			 */
			smartVerifyReq.setAddSignatureForm(true);

			// Datos a verificar.
			smartVerifyReq.setSignatureXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/" + signName)));
			
			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			/*
			 * 0 para consultar la primera y nica firma. Sin una invocacin
			 * previa de setAddSignatureForm(true), este mtodo devuelve null.
			 */
			System.out.println("Verificando firma con formato: " + smartVerifyResp.getSignature(0).getSignatureForm());

			// Se comprueba la validez de la respuesta de Verificacin de firma
			// PKCS#7.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
				System.out.println("ResultMajor: " + smartVerifyResp.getResultMajor());
				System.out.println("ResultMinor: " + smartVerifyResp.getResultMinor());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}